% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache}
\alias{cache}
\alias{cache_options_set}
\alias{cache_options_get}
\title{Set or get cache options}
\usage{
cache_options_set(path = "fulltext", backend = "ext", overwrite = FALSE)

cache_options_get()
}
\arguments{
\item{path}{(character) End of directory path. Default: "fulltext".
See Details.}

\item{backend}{(character) Only "ext" supported for now.}

\item{overwrite}{(logical) overwrite cached file or not. Default: \code{FALSE}}
}
\description{
Set or get cache options
}
\section{Managing cached files}{

The dafault cache directory is \code{paste0(rappdirs::user_cache_dir(), "/R/fulltext")},
but you can set your own path using \code{cache_path_set()}

\code{cache_delete} only accepts 1 file name, while
\code{cache_delete_all} doesn't accept any names, but deletes all files.
For deleting many specific files, use \code{cache_delete} in a \code{\link[=lapply]{lapply()}}
type call
}

\examples{
\dontrun{
cache_options_get()
cache_options_set(path = "foobar")
cache_options_get()
}
}
\seealso{
\link{ftxt_cache}
}
