% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_volume.R
\name{vol.boundary.box}
\alias{vol.boundary.box}
\title{Compute 3D bounding box of a volume.}
\usage{
vol.boundary.box(volume, threshold = 0L, apply = FALSE)
}
\arguments{
\item{volume}{a 3D image volume}

\item{threshold}{numerical, the threshold intensity used to separate background and foreground. All voxels with intensity values greater than this value will be considered `foreground` voxels.}

\item{apply}{logical, whether to directly apply the bounding box and return the resulting volume instead.}
}
\value{
named list with 2 entries: `from` is an integer vector of length 3, defining the minimal (x,y,z) foreground indices. `to` is an integer vector of length 3, defining the maximal (x,y,z) foreground indices.
}
\description{
Compute the axis-aligned foreground bounding box of a 3D volume, i.e. the inner foreground area that must be retained if you want to remove all background from the corners of the volume. The foreground is determined by thresholding, such that all values greater than 0 are considered foreground. See \code{\link[fsbrain]{vol.boundary.mask}} for details.
}
\seealso{
Other volume utility: 
\code{\link{vol.imagestack}()},
\code{\link{vol.merge}()},
\code{\link{vol.overlay.colors.from.activation}()},
\code{\link{vol.planes}()},
\code{\link{vol.slice}()}
}
\concept{volume utility}
