% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.color.on.subject}
\alias{vis.color.on.subject}
\title{Visualize pre-defined vertex colors on a subject.}
\usage{
vis.color.on.subject(
  subjects_dir,
  vis_subject_id,
  color_lh = NULL,
  color_rh = NULL,
  surface = "white",
  views = c("t4"),
  rgloptions = rglo(),
  rglactions = list(),
  color_both = NULL,
  style = "default"
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{vis_subject_id}{string. The subject identifier from which to obtain the surface for data visualization. Example: 'fsaverage'.}

\item{color_lh}{vector of colors to visualize on the left hemisphere surface. Length must match number of vertices in hemi surface, or be a single color.}

\item{color_rh}{vector of colors to visualize on the right hemisphere surface. Length must match number of vertices in hemi surface, or be a single color.}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{views}{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to \code{\link{par3d}}. Example: \code{rgloptions = list("windowRect"=c(50,50,1000,1000))}.}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action. The following example clips outliers in the data before plotting and writes a screenshot in PNG format: \code{rglactions = list("snapshot_png"="~/fsbrain.png", "clip_data"=c(0.05, 0.95))}. See \code{\link{rglactions}}.}

\item{color_both}{vector of colors to visualize on the left and right hemispheres. Alternative to 'color_lh' and 'color_rh'. Length must match sum of vertices in both hemis. Can also be a hemilist.}

\item{style}{character string or rgl rendering style, see \code{\link[fsbrain]{get.rglstyle}}.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Visualize pre-defined vertex colors on a subject.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   color_lh = '#ff0000';
   num_verts_subject1_rh = 153333;
   color_rh = rep('#333333', num_verts_subject1_rh);
   color_rh[1:30000] = '#00ff00';
   color_rh[30001:60000] = '#ff0000';
   color_rh[60001:90000] = '#0000ff';
   color_rh[90001:120000] = '#ffff00';
   color_rh[120001:150000] = '#00ffff';
   vis.color.on.subject(subjects_dir, 'subject1', color_lh, color_rh);
}

}
\seealso{
Other visualization functions: 
\code{\link{highlight.vertices.on.subject.spheres}()},
\code{\link{highlight.vertices.on.subject}()},
\code{\link{vis.data.on.fsaverage}()},
\code{\link{vis.data.on.subject}()},
\code{\link{vis.labeldata.on.subject}()},
\code{\link{vis.mask.on.subject}()},
\code{\link{vis.region.values.on.subject}()},
\code{\link{vis.subject.annot}()},
\code{\link{vis.subject.label}()},
\code{\link{vis.subject.morph.native}()},
\code{\link{vis.subject.morph.standard}()},
\code{\link{vis.subject.pre}()},
\code{\link{vis.symmetric.data.on.subject}()},
\code{\link{vislayout.from.coloredmeshes}()}

Other surface visualization functions: 
\code{\link{highlight.vertices.on.subject.spheres}()},
\code{\link{highlight.vertices.on.subject}()}
}
\concept{surface visualization functions}
\concept{visualization functions}
