% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_group.R
\name{vis.group.coloredmeshes}
\alias{vis.group.coloredmeshes}
\title{Plot coloredmeshes for a group of subjects.}
\usage{
vis.group.coloredmeshes(
  coloredmeshes,
  view_angles = "sd_dorsal",
  output_img = "fsbrain_group_annot.png",
  num_per_row = 5L,
  captions = NULL
)
}
\arguments{
\item{coloredmeshes}{a list of coloredmeshes lists, each entry in the outer list contains the hemilist of coloredmeshes (lefgt and right hemisphere mesh) for one subject.}

\item{view_angles}{see \code{\link{get.view.angle.names}}.}

\item{output_img}{character string, the file path for the output image. Should end with '.png'.}

\item{num_per_row}{positive integer, the number of tiles per row.}

\item{captions}{optional vector of character strings, the short text annotations for the individual tiles. Typically used to plot the subject identifier.}
}
\value{
named list, see the return value of \code{\link{arrange.brainview.images.grid}} for details.
}
\description{
Plot coloredmeshes for a group of subjects into a single image.
}
\note{
This is a mid-level function, end users may want to call high-level functions like \code{\link{vis.group.annot}} instead.
}
\seealso{
Other group visualization functions: 
\code{\link{vis.data.on.group.native}()},
\code{\link{vis.data.on.group.standard}()},
\code{\link{vis.group.annot}()},
\code{\link{vis.group.morph.native}()},
\code{\link{vis.group.morph.standard}()}
}
\concept{group visualization functions}
