% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coloredmesh.R
\name{coloredmesh.from.preloaded.data}
\alias{coloredmesh.from.preloaded.data}
\title{Generate coloredmesh from loaded data.}
\usage{
coloredmesh.from.preloaded.data(
  fs_surface,
  morph_data = NULL,
  col = NULL,
  hemi = "lh",
  makecmap_options = mkco.seq()
)
}
\arguments{
\item{fs_surface}{an fs.surface instance}

\item{morph_data}{numerical vector, per-vertex data (typically morphometry) for the mesh. If given, takes precedence over 'col' parameter.}

\item{col}{vector of colors, typically hex color strings like '#FF00FF'. The per-vertex-colors for the mesh. Alternative to morph_data.}

\item{hemi}{character string, one of 'lh' or 'rh'. Metadata, the hemisphere. May be used by visualization functions to decide whether to draw the mesh in certain views.}

\item{makecmap_options}{named list of parameters to pass to \code{\link{makecmap}}. Must not include the unnamed first parameter, which is derived from 'measure'.}
}
\value{
as fs.coloredmesh instance
}
\description{
Generate coloredmesh from loaded data.
}
