% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_atlas_agg.R
\name{write.region.values.fsaverage}
\alias{write.region.values.fsaverage}
\title{Write one value per atlas region for a template subject.}
\usage{
write.region.values.fsaverage(
  hemi,
  atlas,
  region_value_list,
  output_file,
  template_subject = "fsaverage",
  template_subjects_dir = NULL,
  show_freeview_tip = FALSE,
  value_for_unlisted_regions = NaN
)
}
\arguments{
\item{hemi, }{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{atlas, }{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{region_value_list, }{named list. A list in which the names are atlas regions, and the values are the value to write to all vertices of that region.}

\item{output_file, }{string or `NULL`. Path of the output file, including file name and extension. The format is determined from the (absence of a) file extension. If NULL, no file will be written.}

\item{template_subject}{string, template subject name. Defaults to 'fsaverage'.}

\item{template_subjects_dir}{string, the path to the subjects directory containing the template subject directory. If this is `NULL`, the function will try to find it using the environment, see the function \code{\link[fsbrain]{find.subjectsdir.of}} for details. Defaults to NULL.}

\item{show_freeview_tip}{logical, whether to print the freeview command on howto use the overlay to the console. (Only happens if the output_file is not `NULL`.)}

\item{value_for_unlisted_regions, }{numeric scalar. The value to assign to vertices which are part of atlas regions that are not listed in region_value_list. Defaults to NaN.}
}
\value{
a named list with the following entries: "data": a vector containing the data. "file_written": string, path to the file that was written, only exists if do_write = TRUE.
}
\description{
Given an atlas and a list that contains one value for each atlas region, write a morphometry file in which all region vertices are assigned the value. Can be used to plot stuff like p-values or effect sizes onto brain regions.
}
\seealso{
Other output functions: 
\code{\link{write.region.aggregated}()},
\code{\link{write.region.values}()}
}
\concept{output functions}
