% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_volume.R
\name{rotate3D}
\alias{rotate3D}
\title{Rotate a 3D array in 90 degree steps.}
\usage{
rotate3D(volume, axis = 1L, degrees = 90L)
}
\arguments{
\item{volume}{a 3D image volume}

\item{axis}{positive integer in range 1L..3L or an axis name, the axis to use.}

\item{degrees}{integer, must be a (positive or negative) multiple of 90L.}
}
\value{
a 3D image volume, rotated around the axis. The dimensions may or may not be different from the input image, depending on the rotation angle.
}
\description{
Rotate a 3D array in 90 degree steps along an axis. This leads to an array with different dimensions.
}
\examples{
\donttest{
   # Load data
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   brain = subject.volume(subjects_dir, 'subject1', 'brain') / 255;
   # Show a lightbox along the third axis. Note that the orientation in the
   #  visualization is not very intuitive: the brain lies on the side.
   volvis.lightbox(brain, axis=3);
   # Rotate the whole brain volume by 90 degrees clockwise along
   #  the third axis to fix the orientation:
   volvis.lightbox(rotate3D(brain, axis=3, degrees = 90), axis=3);
}

}
\seealso{
Other volume math: 
\code{\link{flip3D}()}
}
\concept{volume math}
