% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_group.R
\name{group.morph.standard}
\alias{group.morph.standard}
\title{Retrieve standard space morphometry data for a group of subjects.}
\usage{
group.morph.standard(subjects_dir, subjects_list, measure, hemi,
  fwhm = "10", template_subject = "fsaverage", format = "mgh")
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subjects_list, }{vector of strings. The subject identifiers.}

\item{measure, }{string. Name of the vertex-wise measure of morphometry data file. E.g., "area" or "thickness". Used to construct the name of the morphometry file to be loaded.}

\item{hemi, }{string, one of 'lh', 'rh' or 'both'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{fwhm, }{string. Smoothing as string, e.g. '10' or '25'.}

\item{template_subject, }{string. Template subject name, defaults to 'fsaverage'.}

\item{format, }{string. One of 'mgh', 'mgz', 'curv'. Defaults to 'mgh'.}
}
\value{
named list with standard space morph data, the names are the subject identifiers from the subjects_list, and the values are morphometry data vectors (all with identical length, the data is mapped to a template subject).
}
\description{
Load standard space morphometry data (like 'surf/lh.area') for a group of subjects from disk. Uses knowledge about the FreeSurfer directory structure to load the correct file.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   subjects_list = c("subject1", "subject2");
   data = group.morph.standard(subjects_dir, subjects_list, "thickness", "lh", fwhm='10');
}

}
\seealso{
Other morphometry data functions: \code{\link{group.morph.native}},
  \code{\link{subject.morph.native}},
  \code{\link{subject.morph.standard}}
}
\concept{morphometry data functions}
