% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_subject.R
\name{subject.annot}
\alias{subject.annot}
\title{Load an annotation for a subject.}
\usage{
subject.annot(subjects_dir, subject_id, hemi, atlas)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id, }{string. The subject identifier}

\item{hemi, }{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{atlas, }{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}
}
\value{
the annotation, as returned by freesurferformats::read.fs.annot().
}
\description{
Load a brain surface annotation, i.e., a cortical parcellation based on an atlas, for a subject.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   annot_lh = subject.annot(subjects_dir, "subject1", "lh", "aparc");
}

}
\seealso{
Other atlas functions: \code{\link{get.atlas.region.names}},
  \code{\link{group.agg.atlas.native}},
  \code{\link{group.agg.atlas.standard}},
  \code{\link{group.annot}},
  \code{\link{regions.to.ignore}},
  \code{\link{spread.values.over.annot}},
  \code{\link{spread.values.over.hemi}},
  \code{\link{spread.values.over.subject}},
  \code{\link{subject.atlas.agg}}
}
\concept{atlas functions}
