% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_available_qualitycodes.R
\name{get_available_qualitycodes}
\alias{get_available_qualitycodes}
\title{Get metadata on existing quality flags in the "observation" resource}
\usage{
get_available_qualitycodes(client_id,
                           fields = NULL,
                           language = NULL,
                           return_response = FALSE)
}
\arguments{
\item{client_id}{A string. The client ID to use to send requests to the Frost
API.}

\item{fields}{A character vector. The field to include in the response (i.e.
output). If this parameter is set, then only the specified field is
returned as a data frame. If not set, then all fields will be
returned in the response as a list. The options are "summarized" and
"details".}

\item{language}{A string. The language of the fields in the response. The
options are "en-US" (default), "nb-NO" (Norwegian, Bokmål), and "nn-NO"
(Norwegian, Nynorsk).}

\item{return_response}{A logical. If set to \code{TRUE}, then the function
returns the response from the GET request. If set to \code{FALSE} (default),
then the function returns a tibble (data frame) of the content in the
response.}
}
\value{
The function returns either a data frame with metadata about
quality flags, or the response of the GET request, depending
on the boolean value set for \code{return_response}.
}
\description{
\code{get_available_qualitycodes()} provides a data frame with all
possible detail values given the quality service. The function requires
input for \code{client_id}. The other function arguments are optional, and default
to \code{NULL}, which means that the response from the API is not
filtered on these parameters.
}
\examples{
\donttest{
client.id <- "<YOUR CLIENT ID>"

# Get metadata for quality codes
qualitycodes <- get_available_qualitycodes(client_id = client.id)

# Get the summarized metadata for quality codes
summarized.df <- get_available_qualitycodes(client_id = client.id,
                                            fields = "summarized")
}

}
