% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{running_apx_quantiles}
\alias{running_apx_median}
\alias{running_apx_quantiles}
\title{Compute approximate quantiles over a sliding window}
\usage{
running_apx_quantiles(v, p, window = NULL, max_order = 5L, na_rm = FALSE,
  min_df = 0L, used_df = 0L, restart_period = 100L)

running_apx_median(v, window = NULL, max_order = 5L, na_rm = FALSE,
  min_df = 0L, used_df = 0L, restart_period = 100L)
}
\arguments{
\item{v}{a vector}

\item{p}{the probability points at which to compute the quantiles. Should be in the range (0,1).}

\item{window}{the window size. if given as finite integer or double, passed through.
If \code{NULL}, \code{NA_integer_}, \code{NA_real_} or \code{Inf} are given, equivalent
to an infinite window size. If negative, an error will be thrown.}

\item{max_order}{the maximum order of the centered moment to be computed.}

\item{na_rm}{whether to remove NA, false by default.}

\item{min_df}{the minimum df to return a value, otherwise \code{NaN} is returned.
This can be used to prevent moments from being computed on too few observations.
Defaults to zero, meaning no restriction.}

\item{used_df}{the number of degrees of freedom consumed, used in the denominator
of the centered moments computation. These are subtracted from the number of
observations.}

\item{restart_period}{the recompute period. because subtraction of elements can cause
loss of precision, the computation of moments is restarted periodically based on 
this parameter. Larger values mean fewer restarts and faster, though less accurate
results. Note that the code checks for negative second and fourth moments and
recomputes when needed.}
}
\value{
A matrix, with one row for each element of \code{x}, and one column for each element of \code{q}.
}
\description{
Computes cumulants up to some given order, then employs the Cornish-Fisher approximation
to compute approximate quantiles using a Gaussian basis.
}
\details{
Computes the cumulants, then approximates quantiles using AS269 of Lee & Lin.
}
\note{
The current implementation is not as space-efficient as it could be, as it first computes
the cumulants for each row, then performs the Cornish-Fisher approximation on a row-by-row
basis. In the future, this computation may be moved earlier into the pipeline to be more
space efficient. File an issue if the memory footprint is an issue for you.

The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{
x <- rnorm(1e5)
xq <- running_apx_quantiles(x,c(0.1,0.25,0.5,0.75,0.9))
xm <- running_apx_median(x)

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Lee, Y-S., and Lin, T-K. "Algorithm AS269: High Order Cornish Fisher
Expansion." Appl. Stat. 41, no. 1 (1992): 233-240. 
\url{http://www.jstor.org/stable/2347649}

Lee, Y-S., and Lin, T-K. "Correction to Algorithm AS269: High Order 
Cornish Fisher Expansion." Appl. Stat. 42, no. 1 (1993): 268-269. 
\url{http://www.jstor.org/stable/2347433}

AS 269. \url{https://web.archive.org/web/20110103030111/http://lib.stat.cmu.edu/apstat/269}

Jaschke, Stefan R. "The Cornish-Fisher-expansion in the context of 
Delta-Gamma-normal approximations." No. 2001, 54. Discussion Papers, 
Interdisciplinary Research Project 373: Quantification and Simulation of 
Economic Processes, 2001. 
\url{http://www.jaschke-net.de/papers/CoFi.pdf}

Terriberry, T. "Computing Higher-Order Moments Online."
\url{http://people.xiph.org/~tterribe/notes/homs.html}

J. Bennett, et. al., "Numerically Stable, Single-Pass, 
Parallel Statistics Algorithms," Proceedings of IEEE
International Conference on Cluster Computing, 2009.
\url{https://www.semanticscholar.org/paper/Numerically-stable-single-pass-parallel-statistics-Bennett-Grout/a83ed72a5ba86622d5eb6395299b46d51c901265}

Cook, J. D. "Accurately computing running variance."
\url{http://www.johndcook.com/standard_deviation.html}

Cook, J. D. "Comparing three methods of computing 
standard deviation."
\url{http://www.johndcook.com/blog/2008/09/26/comparing-three-methods-of-computing-standard-deviation}
}
\seealso{
\code{\link{running_cumulants}}, \code{PDQutils::qapx_cf}, \code{PDQutils::AS269}.
}

