% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_tabs}
\alias{bs_vars_tabs}
\title{Bootstrap tabs variables}
\usage{
bs_vars_tabs(
  border_color = NULL,
  link_hover_border_color = NULL,
  active_link_hover_bg = NULL,
  active_link_hover_color = NULL,
  active_link_hover_border_color = NULL,
  justified_link_border_color = NULL,
  justified_active_link_border_color = NULL
)
}
\arguments{
\item{border_color}{Border color.}

\item{link_hover_border_color}{Link hover color.}

\item{active_link_hover_bg}{Active link hover background color.}

\item{active_link_hover_color}{Active link hover color.}

\item{active_link_hover_border_color}{Active link hover border color.}

\item{justified_link_border_color}{Justified link border color.}

\item{justified_active_link_border_color}{Justified active link border color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 pills (e.g. \code{\link[shiny:tabsetPanel]{shiny:tabsetPanel}}
 in Bootstrap and Bootswatch themes.
}
\examples{
bs_vars_tabs(
  border_color = "#FF0000", # red
  link_hover_border_color = "#FFFF00", # yellow
  active_link_hover_bg = "#FF00FF", # pink
  active_link_hover_color = "#FFF" # white
)

if (interactive()) {
  library(shiny)
  library(fresh)

  ui <- fluidPage(
    use_theme(create_theme(
      theme = "default",
      bs_vars_global(
        link_color = "#00FF00" #green
      ),
      bs_vars_tabs(
        border_color = "#FF0000", # red
        link_hover_border_color = "#FFFF00", # yellow
        active_link_hover_bg = "#FF00FF", # pink
        active_link_hover_color = "#FFF" # white
      )
    )),
    tags$h1("Tabs panel"),

    sidebarLayout(
      sidebarPanel(),
      mainPanel(
        tabsetPanel(
          tabPanel("Plot", plotOutput("plot")),
          tabPanel("Summary", verbatimTextOutput("summary")),
          tabPanel("Table", tableOutput("table"))
        )
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
