% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_category_series.R
\name{fredr_category_series}
\alias{fredr_category_series}
\title{Get the series in a category}
\usage{
fredr_category_series(
  category_id,
  ...,
  filter_variable = NULL,
  filter_value = NULL,
  tag_names = NULL,
  exclude_tag_names = NULL,
  limit = NULL,
  offset = NULL,
  order_by = NULL,
  sort_order = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{category_id}{An integer ID for the category.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{filter_variable}{A string indicating which attribute to indicate the
attribute that results are filtered by.  Possible values include: \code{"frequency"},
\code{"units"}, \code{"seasonal_adjustment"}.  No filtering by default.}

\item{filter_value}{A string giving the value of the \code{filter_variable}
attribute to filter results by.  \code{filter_variable} must be set.  No filtering
by default.}

\item{tag_names}{A string indicating which series tags to match.  Multiple
tags can be delimited by a semicolon in a single string (e.g. \code{"usa;gnp"}).}

\item{exclude_tag_names}{A string indicating which series tags should \emph{not}
be matched.  Multiple tags can be delimited by a semicolon in a single string
(e.g. `"usa;gnp"``).}

\item{limit}{An positive integer indicating maximum number of results to
return.  Possible values are any integer between \code{1} and \code{1000} (default),
inclusive.}

\item{offset}{An non-negative integer used in conjunction with \code{limit} for
long series.  This mimics the idea of \emph{pagination} to retrieve large amounts
of data over multiple calls. Defaults to \code{0}.}

\item{order_by}{A string indicating an attribute by which the results are
ordered by. Possible values include:
\itemize{
\item \code{"series_id"} (default)
\item \code{"title"}
\item \code{"units"}
\item \code{"frequency"}
\item \code{"seasonal_adjustment"}
\item \code{"realtime_start"}
\item \code{"realtime_end"}
\item \code{"last_updated"}
\item \code{"observation_start"}
\item \code{"observation_end"}
\item \code{"popularity"}
\item \code{"group_popularity"}
}}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object with information for series matching the request for
the category specified in \code{category_id}.
}
\description{
Get the series in a category
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/category_series.html}{fred/category/series}
}

\examples{
if (fredr_has_key()) {
# Top 10 most popular series belonging to the "Employment Cost Index" category
fredr_category_series(category_id = 1L, limit = 10L, order_by = "popularity")
# Series in the "Employment Cost Index" category, ordered by descending observation frequency
fredr_category_series(category_id = 4L, order_by = "frequency", sort_order = "desc")
}
}
\seealso{
\code{\link[=fredr_category]{fredr_category()}}, \code{\link[=fredr_category_children]{fredr_category_children()}}, \code{\link[=fredr_category_related]{fredr_category_related()}},
\code{\link[=fredr_category_tags]{fredr_category_tags()}}, \code{\link[=fredr_category_related_tags]{fredr_category_related_tags()}}
}
