% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.jointSurroMed.R
\name{summary.jointSurroMed}
\alias{summary.jointSurroMed}
\alias{print.summary.jointSurroMed}
\title{Short summary of the random effects parameters, the fixed treatment
effects, and the surrogacy evaluation criteria estimated from a joint surrogate mediation model}
\usage{
\method{summary}{jointSurroMed}(object,d=4,len=3,n=3,...)
}
\arguments{
\item{object}{An object inheriting from \code{jointSurroMed} class.}

\item{d}{The desired number of digits after the decimal point for parameters.
The maximum of 4 digits is required for the estimates. Default of 3 digits is used.}

\item{len}{The desired number of digits after the decimal point for p-value and convergence
criteria. Default of 4 digits is used.}

\item{n}{The number of time points to be used in the results of the differents function
related to the mediation analysis: \eqn{g(s)}, \eqn{PTE(t)} and the direct, indirect and total
effect. The provided value should be between 1 and 20. Default is 3.}

\item{...}{other unused arguments.}
}
\value{
For the variances parameters of the random effects, it prints the estimate of
the coefficients with their standard error, Z-statistics and p-values
of the Wald test. For the fixed treatment effects, it also prints HR and its confidence
intervals for each covariate.
For the surrogacy assessment, prints \code{n} value of the estimation function \eqn{g(s)} and \eqn{PTE(t)}.
Also prints the values of the estimated direct, indirect and total effects.
The remaining displayed information concern the convergence characteristics and
include the penalized marginal log-likelihood, the number of iterations, the LCV and the convergence criteria.
}
\description{
This function returns the estimate of the coefficients of the model, their standard error and the
associated p-values of the Wald test for the joint surrogate model, also hazard ratios (HR) and their
confidence intervals for the fixed treatment effects. It also displays summary of the surrogacy measure \eqn{PTE(t)}
and of the natural direct, indirect and total effect.
}
\seealso{
\code{\link{jointSurroPenal}}
}
\keyword{methods}
