% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractionl.R
\name{fractional}
\alias{as.character.fractional}
\alias{fractional}
\alias{print.charFrac}
\alias{print.fractional}
\title{Representation of a numeric vector in vulgar fractional form}
\usage{
fractional(x, eps = 1e-06, maxConv = 20, sync = FALSE)

\method{as.character}{fractional}(x, eps = attr(x, "eps"), maxConv = attr(x,
  "maxConv"), ...)

\method{print}{charFrac}(x, ...)

\method{print}{fractional}(x, ...)
}
\arguments{
\item{x}{A numeric object}

\item{eps}{An absolute error tolerance}

\item{maxConv}{An upper limit on the number of convergents to use in the
continued fractions.}

\item{sync}{A logical value.  Should the numerical value be changed to match
the rational approximation, as closely as possible with floating point, (TRUE)? Or,
should it be left and used in its original state (FALSE)?}

\item{...}{Currently ignored.}
}
\value{
A numeric object of class \code{"fractional"}.
}
\description{
The object is flagged so that if it is coerced to \code{character},
or printed, the numerical quantities are represented by a rational
approximation.  In other respects the numerical object behaves as
normally.
}
\section{Methods (by generic)}{
\itemize{
\item \code{as.character}: S3 method for coercion to character,
producing an object inheriting from class \code{"charFrac"}

\item \code{print}: Print method for class \code{"charFrac"} objects, unquoted.

\item \code{print}: Print method for \code{"fractional"} objects
}}
\examples{
(M <- solve(cbind(1, contr.helmert(5))))
(Mf <- fractional(M))     ## print method right justifies
(Mc <- as.character(Mf))  ## print method left justifies
(Mn <- numerical(Mc))
set.seed(123)
u <- matrix(runif(10), 2, 5)
(uf <- fractional(u))
(us <- fractional(u, sync = TRUE))  ## may look different!
unfractional(uf) - unfractional(us)  ## rational approximation errors
}
\seealso{
\code{\link[MASS]{fractions}} for a similar functionality.
}

