% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_database.R
\name{download_database}
\alias{download_database}
\title{Download a single floristic quality database}
\usage{
download_database(database_id)
}
\arguments{
\item{database_id}{A numeric identifier of the desired floristic quality
database, as specified by
\href{https://universalfqa.org/}{universalfqa.org}. ID numbers for
databases recognized this site can be viewed with the
\code{\link[=index_fqa_databases]{index_fqa_databases()}} function.}
}
\value{
An untidy data frame in the original format of the Universal FQA
  website. Use \code{\link[=database_glance]{database_glance()}} for a tidy
  summary and \code{\link[=database_inventory]{database_inventory()}} for
  species-level data.
}
\description{
\code{download_database()} retrieves a specified floristic quality database
from \href{https://universalfqa.org/}{universalfqa.org}. A list of available
databases can be found using the
\code{\link[=index_fqa_databases]{index_fqa_databases()} } function.
}
\examples{
databases <- index_fqa_databases() # Database 1 is the original 1994 Chicago edition.

chicago_database <- download_database(1)

}
