% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment_list_inventory.R
\name{assessment_list_inventory}
\alias{assessment_list_inventory}
\title{Obtain species details for a list of floristic quality assessments}
\usage{
assessment_list_inventory(assessment_list)
}
\arguments{
\item{assessment_list}{A list of data sets downloaded from
\href{https://universalfqa.org/}{universalfqa.org}, typically using
\code{\link[=download_assessment_list]{download_assessment_list()}}.}
}
\value{
A list of data frames, each with 9 columns:
\itemize{
   \item scientific_name (character)
   \item family (character)
   \item acronym (character)
   \item nativity (character)
   \item c (numeric)
   \item w (numeric)
   \item physiognomy (character)
   \item duration (character)
   \item common_name (character)
}
}
\description{
\code{assessment_list_inventory()} returns a list of data frames, each of which
consists of all plant species included in a floristic quality assessment
obtained from \href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
\donttest{
# While assessment_list_inventory can be used with a list of .csv file downloaded
# manually from the universal FQA website, it is most typically used
# in combination with download_assessment_list().

ontario <- download_assessment_list(database = 2)
ontario_invs <- assessment_list_inventory(ontario)
}

}
