% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{partition}
\alias{partition}
\title{Split data into training and testing sets}
\usage{
partition(
  x,
  type = "group holdout",
  p = 0.75,
  kfold = 5,
  groups = min(5, length(x)),
  returnTrain = TRUE
)
}
\arguments{
\item{x}{A vector used for splitting data}

\item{type}{Character. Type of partition. Valid values are \code{"random
holdout"}, \code{"group holdout"} or \code{"kfold"}}

\item{p}{percentage of data that goes to training set (holdout). Only
relevant if \code{type = "random holdout"} or \code{type = "group holdout"}}

\item{kfold}{Number of folds for cross-validation. Only relevant if  \code{type =
"kfold"}.}

\item{groups}{For \code{"group holdout"} and when x is numeric, this is the number
of breaks in the quantiles}

\item{returnTrain}{Logical indicating whether training or validation indices
should be returned. Default is TRUE.}
}
\value{
List containing training or validation indices
}
\description{
Returns the row indices of \code{x} that should go to training or validation.
}
\details{
Three types of splits are currently implemented. \code{"random holdout"} randomly
selects \code{p} percents of \code{x} for the training set. \code{"group holdout"}
first groups \code{x} into \code{groups} quantiles and randomly samples
within them (see \code{\link[caret]{createDataPartition}}) . \code{"kfold"}
creates k folds where p percent of the data is used for training in each fold
(see \code{createFolds}). This function is a wrapper around two functions of
\code{caret} package: \code{\link[caret]{createDataPartition}} and
\code{createFolds}
}
\examples{
# sample_points is a SpatialPointsDataFrame calculated and saved from getSample
# Load it into memory
load(system.file("extdata/examples/sample_points.RData",package="foster"))

partition(sample_points$cluster, type = "kfold", kfold = 5)
}
\seealso{
\code{\link[caret]{createDataPartition}}
}
