% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UD_Server.R
\name{UD_attach_ds}
\alias{UD_attach_ds}
\title{Attach Data Set to UD State}
\usage{
UD_attach_ds(
  state,
  clean = NULL,
  isgood = TRUE,
  load_msg = NULL,
  data_file_local = NULL,
  data_file_ext = NULL,
  data_file = NULL,
  sheet = NULL,
  sheets = NULL,
  code = "",
  object_name = NULL,
  contents = NULL
)
}
\arguments{
\item{state}{UD state module.}

\item{clean}{Boolean switch to determine if the headers in the loaded dataset was cleaned.}

\item{isgood}{Boolean object indicating if the file was successfully loaded.}

\item{load_msg}{Text message indicated the success or any problems encountered when uploading the file.}

\item{data_file_local}{Full path to the data file on the server.}

\item{data_file_ext}{File extension of the uploaded file.}

\item{data_file}{Dataset file name without the path.}

\item{sheet}{If the uploaded file is an excel file, this is the currently selected sheet.}

\item{sheets}{If the uploaded file is an excel file, this is a character vector of the sheets present in that file.}

\item{code}{Code to load dataset.}

\item{object_name}{Name of the dataset object created when code is evaluated.}

\item{contents}{Data frame containting the contents of the data file.}
}
\value{
state with data set attached
}
\description{
Attaches a dataset to the UD state supplied.
}
\examples{
# We need a module state object to use this function:
id="UD"
sess_res = UD_test_mksession(session=list())
state = sess_res$state

# This is the full path to a test data file:
data_file_local  =  system.file(package="formods", "test_data", "TEST_DATA.xlsx")

# Excel file extension
data_file_ext    = "xlsx"

# Base file name
data_file        = "TEST_DATA.xlsx"

# Excel files need a sheet specification:
sheet           = "DATA"

# We will also attach the sheets along with it
sheets = readxl::excel_sheets(data_file_local)

ds_read_res = UD_ds_read(state,
  data_file_ext   = data_file_ext,
  data_file_local = data_file_local,
  data_file       = data_file,
  sheets          = sheets,
  sheet          = sheet)

# This would contain the loading code that will cascade down
# to the other modules when generating snippets and
# reproducible scripts
code = ds_read_res$code

# This is the R Object name that is used internally
# and in generated scripts. Should be the same as in
# the code above
object_name = ds_read_res$object_name

# This is the actual dataset:
contents   = ds_read_res$contents

state =  UD_attach_ds(
         state,
         data_file_local = data_file_local,
         data_file_ext   = ".xlsx",
         data_file       = data_file,
         sheet           = sheet,
         sheets          = sheets,
         code            = code,
         object_name     = object_name,
         contents        = contents)

state
}
