% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpf_exporters.R
\name{export_as_rtf}
\alias{export_as_rtf}
\title{Export table to \code{RTF}}
\usage{
export_as_rtf(
  x,
  file = NULL,
  colwidths = propose_column_widths(matrix_form(x, TRUE)),
  page_type = "letter",
  pg_width = page_dim(page_type)[if (landscape) 2 else 1],
  pg_height = page_dim(page_type)[if (landscape) 1 else 2],
  landscape = FALSE,
  margins = c(bottom = 0.5, left = 0.75, top = 0.5, right = 0.75),
  font_size = 8,
  font_family = "Courier",
  ...
)
}
\arguments{
\item{x}{ANY.  The  table-like object  to  export.  Must have  an
applicable \code{matrix_form} method.}

\item{file}{character(1) or NULL.  If non-NULL, the path to write a
text file to containing the \code{x} rendered as ASCII text,}

\item{colwidths}{numeric vector.  Column widths (in characters) for
use with vertical pagination.}

\item{page_type}{character(1).   Name   of  a  page  type.   See
\code{page_types}.   Ignored when  \code{pg_width} and  \code{pg_height}
are set directly.}

\item{pg_width}{numeric(1). Page width in inches.}

\item{pg_height}{numeric(1). Page height in inches.}

\item{landscape}{logical(1). Should the  dimensions of \code{page_type}
be inverted  for landscape?  Defaults to  \code{FALSE}, ignored when
\code{pg_width} and \code{pg_height} are set directly.}

\item{margins}{numeric(4). Named numeric vector containing \code{'bottom'},
\code{'left'}, \code{'top'}, and \code{'right'} margins in inches. Defaults
to \code{.5} inches for both vertical margins and \code{.75} for both
horizontal margins.}

\item{font_size}{numeric(1). Font size, defaults to 12.}

\item{font_family}{character(1). Name of a font family. An error
will be thrown if the family named is not monospaced. Defaults
to Courier.}

\item{...}{Passed to individual methods.}
}
\description{
Experimental export to the \code{RTF} format.
}
\details{
\code{RTF} export occurs by via the following steps

\itemize{
\item{the table is paginated to the page size (Vertically and horizontally)}
\item{Each separate page is converted to a \code{MatrixPrintForm} and from there to \code{RTF}-encoded text}
\item{Separate \code{RTFs} text chunks are combined and written out as a single \code{RTF} file}
}

Conversion of \code{MatrixPrintForm} objects to \code{RTF} is done via \code{\link[=mpf_to_rtf]{mpf_to_rtf()}}.
}
