% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canopy-height.R
\name{fd_canopy_height_eth}
\alias{fd_canopy_height_eth}
\title{Forest Canopy Height}
\usage{
fd_canopy_height_eth(
  x = NULL,
  lon = NULL,
  lat = NULL,
  layer = "chm",
  crop = FALSE,
  mask = FALSE,
  merge = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{a \code{sf} or \code{SpatVector} object. It will retrieve the
necessary tiles to cover the area (if \code{lat} and \code{lon} are
specified, this argument is ignored)}

\item{lon}{a number specifying the longitude of the area where we want the tile}

\item{lat}{a number specifying the latitude of the area where we want the tile}

\item{layer}{a string for the layer to download. The default "\code{chm}"
downloads the Canopy Height Model, while "\code{std}" downloads
the standard deviation. If you want both layers, use "\code{all}"}

\item{crop}{when \code{x} is specified, whether to crop the tile(s) to the object}

\item{mask}{when \code{x} is specified, whether to mask the tile(s) to the object}

\item{merge}{if \code{FALSE} (default), it will merge the tiles into one raster.
If \code{FALSE} a SpatRasterCollection will be returned.}

\item{quiet}{if \code{TRUE}, suppress any message or progress bar}
}
\value{
A \code{SpatRaster}
}
\description{
Download the ETH Global Sentinel-2 10m Canopy Height (2020)
}
\details{
Data may be freely used for research, study, or teaching, but be cited
appropriately (see references below).
}
\references{
Lang, Nico, Walter Jetz, Konrad Schindler, and Jan Dirk
Wegner. "A high-resolution canopy height model of the Earth."
arXiv preprint arXiv:2204.08322 (2022).
}
\keyword{internal}
