% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{autolayer.mts}
\alias{autolayer.mts}
\alias{autolayer.msts}
\alias{autolayer.ts}
\alias{autoplot.ts}
\alias{autoplot.mts}
\alias{autoplot.msts}
\alias{fortify.ts}
\title{Automatically create a ggplot for time series objects}
\usage{
\method{autolayer}{mts}(object, colour = TRUE, series = NULL, ...)

\method{autolayer}{msts}(object, series = NULL, ...)

\method{autolayer}{ts}(object, colour = TRUE, series = NULL, ...)

\method{autoplot}{ts}(
  object,
  series = NULL,
  xlab = "Time",
  ylab = deparse(substitute(object)),
  main = NULL,
  ...
)

\method{autoplot}{mts}(
  object,
  colour = TRUE,
  facets = FALSE,
  xlab = "Time",
  ylab = deparse(substitute(object)),
  main = NULL,
  ...
)

\method{autoplot}{msts}(object, ...)

\method{fortify}{ts}(model, data, ...)
}
\arguments{
\item{object}{Object of class \dQuote{\code{ts}} or \dQuote{\code{mts}}.}

\item{colour}{If TRUE, the time series will be assigned a colour aesthetic}

\item{series}{Identifies the timeseries with a colour, which integrates well
with the functionality of \link{geom_forecast}.}

\item{...}{Other plotting parameters to affect the plot.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Main title.}

\item{facets}{If TRUE, multiple time series will be faceted (and unless
specified, colour is set to FALSE). If FALSE, each series will be assigned a
colour.}

\item{model}{Object of class \dQuote{\code{ts}} to be converted to
\dQuote{\code{data.frame}}.}

\item{data}{Not used (required for \link{fortify} method)}
}
\value{
None. Function produces a ggplot graph.
}
\description{
\code{autoplot} takes an object of type \code{ts} or \code{mts} and creates
a ggplot object suitable for usage with \code{stat_forecast}.
}
\details{
\code{fortify.ts} takes a \code{ts} object and converts it into a data frame
(for usage with ggplot2).
}
\examples{

library(ggplot2)
autoplot(USAccDeaths)

lungDeaths <- cbind(mdeaths, fdeaths)
autoplot(lungDeaths)
autoplot(lungDeaths, facets=TRUE)

}
\seealso{
\code{\link[stats]{plot.ts}}, \code{\link[ggplot2]{fortify}}
}
\author{
Mitchell O'Hara-Wild
}
