% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical.R
\docType{data}
\name{bronze}
\alias{bronze}
\title{Chinese Ritual Bronzes}
\format{
A \code{data.frame} with 88 observations and 22 variables (chemical elements):
\describe{
\item{reference}{\code{\link{integer}}: catalog number.}
\item{chronology}{\code{\link{integer}}: chronology (typology).}
\item{dynasty}{ordered \code{\link{factor}}: dynasty name.}
\item{Cu}{\code{\link{numeric}}: Cu content (ppm).}
\item{Sn}{\code{\link{numeric}}: Sn content (ppm).}
\item{Pb}{\code{\link{numeric}}: Pb content (ppm).}
\item{Zn}{\code{\link{numeric}}: Zn content (ppm).}
\item{Au}{\code{\link{numeric}}: Au content (ppm).}
\item{Ag}{\code{\link{numeric}}: Ag content (ppm).}
\item{As}{\code{\link{numeric}}: As content (ppm).}
\item{Sb}{\code{\link{numeric}}: Sb content (ppm).}
}
}
\source{
Wood, J. R. & Liu, Y. (2023). A Multivariate Approach to Investigate
Metallurgical Technology: The Case of the Chinese Ritual Bronzes.
\emph{Journal of Archaeological Method and Theory}, 30: 707-756.
\doi{10.1007/s10816-022-09572-8}.
}
\usage{
bronze
}
\description{
Chemical analysis of 369 Chinese ritual bronzes.
The major elements (Cu, Sn and Pb) were measured using atomic absorption
spectroscopy and the trace elements using neutron activation analysis.
}
\references{
Bagley, R. W. (1987). \emph{Shang ritual bronzes in the Arthur M. Sackler
collections}. New York: The Arthur M. Sackler Foundation.

Rawson, J. (1990). \emph{Western Zhou ritual bronzes from the Arthur M. Sackler
collections}. New York: The Arthur M. Sackler Foundation.

So, J. (1995). \emph{Eastern Zhou ritual bronzes from the Arthur M. Sackler
Collections}. New York: The Arthur M. Sackler Foundation.
}
\seealso{
Other chemical data: 
\code{\link{kommos}},
\code{\link{verre}}
}
\concept{chemical data}
\keyword{datasets}
