% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnets.R
\name{plot.fnets}
\alias{plot.fnets}
\title{Plotting the networks estimated by fnets}
\usage{
\method{plot}{fnets}(
  x,
  type = c("granger", "pc", "lrpc"),
  display = c("network", "heatmap"),
  names = NA,
  groups = NA,
  threshold = 0,
  ...
)
}
\arguments{
\item{x}{\code{fnets} object}

\item{type}{a string specifying which of the above three networks (i)--(iii) to visualise; possible values are
\itemize{
   \item{\code{"granger"}}{ directed network representing Granger causal linkages}
   \item{\code{"pc"}}{ undirected network representing contemporaneous linkages; available when \code{x$do.lrpc = TRUE}}
   \item{\code{"lrpc"}}{ undirected network summarising Granger causal and contemporaneous linkages; available when \code{x$do.lrpc = TRUE}}
}}

\item{display}{a string specifying how to visualise the network; possible values are:
\itemize{
   \item{\code{"network"}}{ as an \code{igraph} object, see \link[igraph]{plot.igraph}}
   \item{\code{"heatmap"}}{ as a heatmap, see \link[fields]{imagePlot}}
}}

\item{names}{a character vector containing the names of the vertices}

\item{groups}{an integer vector denoting any group structure of the vertices}

\item{threshold}{if \code{threshold > 0}, hard thresholding is performed on the matrix giving rise to the network of interest}

\item{...}{additional arguments}
}
\value{
A network plot produced as per the input arguments
}
\description{
Plotting method for S3 objects of class \code{fnets}.
Produces a plot visualising three networks underlying factor-adjusted VAR processes:
(i) directed network representing Granger causal linkages, as given by estimated VAR transition matrices summed across the lags,
(ii) undirected network representing contemporaneous linkages after accounting for lead-lag dependence, as given by partial correlations of VAR innovations,
(iii) undirected network summarising (i) and (ii) as given by long-run partial correlations of VAR processes.
Edge widths are determined by edge weights.
}
\details{
See Barigozzi, Cho and Owens (2022) for further details.
}
\references{
Barigozzi, M., Cho, H. & Owens, D. (2022) FNETS: Factor-adjusted network estimation and forecasting for high-dimensional time series. arXiv preprint arXiv:2201.06110.

Owens, D., Cho, H. & Barigozzi, M. (2022) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling. arXiv preprint arXiv:2301.11675.
}
\seealso{
\link[fnets]{fnets}
}
