% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{fmt_median}
\alias{fmt_median}
\title{Formatted Median}
\usage{
fmt_median(x, format = "\%.1f")
}
\arguments{
\item{x}{The input data vector or data frame column.}

\item{format}{A formatting string suitable for input into the 
\code{\link[base]{sprintf}} function.  By default, this format is
defined as "\%.1f", which displays the value with one decimal place.}
}
\value{
The formatted median value.
}
\description{
A function to calculate and format a median.
}
\details{
This function calculates a median using the stats package
\code{\link[stats]{median}}
function, and then formats the output using \code{\link[base]{sprintf}}.
You may control the format using the \strong{format} parameter.  Function will 
ignore any NA values in the input data. Results are returned as a 
character vector.
}
\examples{
v1 <- c(4.3, 3.7, 8.7, 6.1, 9.2, 5.6, NA, 0.7, 7.8, 4.9)

# Format median
fmt_median(v1)
# "5.6"
}
\seealso{
Other helpers: 
\code{\link{fmt_cnt_pct}()},
\code{\link{fmt_mean_sd}()},
\code{\link{fmt_mean_stderr}()},
\code{\link{fmt_n}()},
\code{\link{fmt_quantile_range}()},
\code{\link{fmt_range}()}
}
\concept{helpers}
