% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_assessment.R
\name{fm_assess}
\alias{fm_assess}
\title{Interactive mesh building and diagnostics}
\usage{
fm_assess(mesh, spatial.range, alpha = 2, dims = NULL)
}
\arguments{
\item{mesh}{An \link{fm_mesh_2d} object}

\item{spatial.range}{numeric; the spatial range parameter to use for the
assessment}

\item{alpha}{numeric; A valid \code{\link[=fm_matern_precision]{fm_matern_precision()}} \code{alpha} parameter}

\item{dims}{2-numeric; the grid size}
}
\value{
An \code{sf} object with gridded mesh assessment information
}
\description{
Assess the finite element approximation errors in a mesh for interactive R
sessions.
}
\examples{

bnd <- fm_segm(cbind(
  c(0, 10, 10, 0, 0),
  c(0, 0, 10, 10, 0)
), is.bnd = TRUE)
mesh <- fm_rcdt_2d_inla(boundary = bnd, max.edge = 1)
out <- fm_assess(mesh, spatial.range = 3, alpha = 2)

}
\seealso{
\code{\link[=fm_mesh_2d]{fm_mesh_2d()}}, \link{fm_rcdt_2d}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
