% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lattice_2d.R
\name{fm_lattice_2d}
\alias{fm_lattice_2d}
\alias{fm_lattice_2d.default}
\title{Make a lattice object}
\usage{
fm_lattice_2d(...)

\method{fm_lattice_2d}{default}(
  x = seq(0, 1, length.out = 2),
  y = seq(0, 1, length.out = 2),
  z = NULL,
  dims = if (is.matrix(x)) {
     dim(x)
 } else {
     c(length(x), length(y))
 },
  units = NULL,
  crs = NULL,
  ...
)
}
\arguments{
\item{...}{Passed on to submethods}

\item{x}{vector or grid matrix of x-values. Vector values are sorted before
use. Matrix input is assumed to be a grid of x-values with the same
ordering convention of \code{as.vector(x)} as \code{rep(x, times = dims[2])} for
vector input.}

\item{y}{vector of grid matrix of y-values. Vector values are sorted before
use. Matrix input is assumed to be a grid of y-values with the same
ordering convention of \code{as.vector(y)} as \code{rep(y, each = dims[1])} for
vector input.}

\item{z}{if x is a matrix, a grid matrix of z-values, with the same ordering
as \code{x} and \code{y}. If \code{x} is a vector, \code{z} is ignored.}

\item{dims}{the size of the grid, length 2 vector}

\item{units}{One of \code{c("default", "longlat", "longsinlat", "mollweide")}
or NULL (equivalent to \code{"default"}).}

\item{crs}{An optional \code{fm_crs}, \code{sf::st_crs}, or \code{sp::CRS} object}
}
\value{
An \code{fm_lattice_2d} object with elements
\describe{
\item{dims}{integer vector}
\item{x}{x-values for original vector input}
\item{y}{y-values for original vector input}
\item{loc}{matrix of \verb{(x, y)} values or \verb{(x, y, z)} values. May be altered by
\code{\link[=fm_transform]{fm_transform()}}}
\item{segm}{\code{fm_segm} object}
\item{crs}{\code{fm_crs} object or \code{NULL}}
}
}
\description{
Construct a lattice grid for \code{\link[=fm_mesh_2d]{fm_mesh_2d()}}
}
\examples{
lattice <- fm_lattice_2d(
  seq(0, 1, length.out = 17),
  seq(0, 1, length.out = 10)
)

## Use the lattice "as-is", without refinement:
mesh <- fm_rcdt_2d_inla(lattice = lattice, boundary = lattice$segm)
mesh <- fm_rcdt_2d_inla(lattice = lattice, extend = FALSE)

## Refine the triangulation, with limits on triangle angles and edges:
mesh <- fm_rcdt_2d(
  lattice = lattice,
  refine = list(max.edge = 0.08),
  extend = FALSE
)

## Add an extension around the lattice, but maintain the lattice edges:
mesh <- fm_rcdt_2d(
  lattice = lattice,
  refine = list(max.edge = 0.08),
  interior = lattice$segm
)

## Only add extension:
mesh <- fm_rcdt_2d(lattice = lattice, refine = list(max.edge = 0.08))
}
\seealso{
\code{\link[=fm_mesh_2d]{fm_mesh_2d()}}

Other object creation and conversion: 
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_mesh_1d}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_segm}()},
\code{\link{fm_simplify}()},
\code{\link{fm_tensor}()}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\concept{object creation and conversion}
