% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FME.R
\name{ForwardMarginalEffect}
\alias{ForwardMarginalEffect}
\title{R6 Class representing a forward marginal effect (FME)}
\description{
The FME is a forward difference in prediction due to a specified change in feature values.
}
\examples{

## ------------------------------------------------
## Method `ForwardMarginalEffect$new`
## ------------------------------------------------


# Train a model:

library(mlr3verse)
library(ranger)
data(bikes, package = "fmeffects")
forest = lrn("regr.ranger")$train(as_task_regr(x = bikes, id = "bikes", target = "count"))

# Create an `ForwardMarginalEffect` object:
effects = ForwardMarginalEffect$new(makePredictor(forest, bikes, "count"),
                  feature = c("temp", "humidity"),
                  step.size = c(1, 0.01),
                  ep.method = "envelope")

## ------------------------------------------------
## Method `ForwardMarginalEffect$compute`
## ------------------------------------------------

# Compute results:
effects$compute()

## ------------------------------------------------
## Method `ForwardMarginalEffect$plot`
## ------------------------------------------------

# Compute results:
effects$plot()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{feature}}{vector of features}

\item{\code{predictor}}{\code{Predictor} object}

\item{\code{step.size}}{vector of step sizes for features specified by "feature"}

\item{\code{data.step}}{the data.table with the data matrix after the step}

\item{\code{ep.method}}{string specifying extrapolation detection method}

\item{\code{compute.nlm}}{logical specifying if NLM should be computed}

\item{\code{nlm.intervals}}{number of intervals for computing NLMs}

\item{\code{step.type}}{\code{"numerical"} or \code{"categorical"}}

\item{\code{extrapolation.ids}}{vector of observation ids classified as extrapolation points}

\item{\code{results}}{data.table with FMEs and NLMs computed}

\item{\code{ame}}{Average Marginal Effect (AME) of observations in \code{results}}

\item{\code{anlm}}{Average Non-linearity Measure (ANLM) of observations in \code{results}}

\item{\code{computed}}{logical specifying if compute() has been run}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ForwardMarginalEffect-new}{\code{ForwardMarginalEffect$new()}}
\item \href{#method-ForwardMarginalEffect-compute}{\code{ForwardMarginalEffect$compute()}}
\item \href{#method-ForwardMarginalEffect-plot}{\code{ForwardMarginalEffect$plot()}}
\item \href{#method-ForwardMarginalEffect-clone}{\code{ForwardMarginalEffect$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForwardMarginalEffect-new"></a>}}
\if{latex}{\out{\hypertarget{method-ForwardMarginalEffect-new}{}}}
\subsection{Method \code{new()}}{
Create a new ForwardMarginalEffect object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForwardMarginalEffect$new(
  predictor,
  feature,
  step.size,
  ep.method = "none",
  compute.nlm = FALSE,
  nlm.intervals = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{\code{Predictor} object.}

\item{\code{feature}}{Feature vector.}

\item{\code{step.size}}{Vector of step sizes.}

\item{\code{ep.method}}{String specifying extrapolation detection method.}

\item{\code{compute.nlm}}{Compute NLM with FMEs? Defaults to \code{FALSE}.}

\item{\code{nlm.intervals}}{How many intervals for NLM computation. Defaults to \code{1}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ForwardMarginalEffect} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{
# Train a model:

library(mlr3verse)
library(ranger)
data(bikes, package = "fmeffects")
forest = lrn("regr.ranger")$train(as_task_regr(x = bikes, id = "bikes", target = "count"))

# Create an `ForwardMarginalEffect` object:
effects = ForwardMarginalEffect$new(makePredictor(forest, bikes, "count"),
                  feature = c("temp", "humidity"),
                  step.size = c(1, 0.01),
                  ep.method = "envelope")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForwardMarginalEffect-compute"></a>}}
\if{latex}{\out{\hypertarget{method-ForwardMarginalEffect-compute}{}}}
\subsection{Method \code{compute()}}{
Computes results, i.e., FME (and NLMs) for non-extrapolation points, for a \code{ForwardMarginalEffect} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForwardMarginalEffect$compute()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{ForwardMarginalEffect} object with results.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Compute results:
effects$compute()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForwardMarginalEffect-plot"></a>}}
\if{latex}{\out{\hypertarget{method-ForwardMarginalEffect-plot}{}}}
\subsection{Method \code{plot()}}{
Plots results, i.e., FME (and NLMs) for non-extrapolation points, for an \code{FME} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForwardMarginalEffect$plot(with.nlm = FALSE, jitter = c(0, 0))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{with.nlm}}{Plots NLMs if computed, defaults to \code{FALSE}.}

\item{\code{jitter}}{Jitters data. A two-dimensional numeric vector, corresponds to \code{"width"} and \code{"height"}. See \code{?ggplot2::geom_jitter} for details.
Not available if \code{step.type} is categorical.
Defaults to no jittering, i.e., c(0, 0).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Compute results:
effects$plot()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForwardMarginalEffect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ForwardMarginalEffect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForwardMarginalEffect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
