#' Tortula data
#'
#' Morphological data on 10 taxa of Tortula labeled C, CC, CCS, I, I, N, N, RF, RH, RS, R, R, V, V.
#'
#' @name tortula
#' @docType data
#'
#' @keywords dataset
#'
#' @format Multivariate data set with 14 cases and 7 variables.
#' \itemize{
#'   \item hydroids: (nominal)
#'   \item leaves: (nominal)
#'   \item hairs: (ordinal)
#'   \item apex: (ordinal)
#'   \item length: (numerical)
#'   \item diameter: (numerical)
#'   \item papillae: (numerical)
#' }
#'
#' @references Podani (1999). Extending Gower's general coefficient of similarity to ordinal characters. Taxon, 48(2), 331-340.
"tortula"
