% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_table.R
\name{export_table}
\alias{export_table}
\title{Write csv, Excel files, txt}
\usage{
export_table(x, file, FUN = data.table::fwrite,
  data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), dir = flyio_get_dir(),
  delete_file = TRUE, show_progress = FALSE, ...)
}
\arguments{
\item{x}{variable name}

\item{file}{path of the file to be written to}

\item{FUN}{the function using which the file is to write}

\item{data_source}{the name of the data source, if not set globally. s3, gcs or local}

\item{bucket}{the name of the bucket, if not set globally}

\item{dir}{the directory to store intermediate files}

\item{delete_file}{logical. to delete the file to be uploaded}

\item{show_progress}{logical. Shows progress of the upload operation.}

\item{...}{other parameters for the FUN function defined above}
}
\value{
No output
}
\description{
Write csv, Excel files, txt
}
\examples{
# for data on local
export_table(iris, paste0(tempdir(), "/iris.csv"), FUN = write.csv, data_source = "local")
\dontrun{
# for data on cloud
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
export_table(iris, "iris.csv", write.csv, dir = tempdir())
}
}
