% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/conf.R
\docType{data}
\name{flowopts}
\alias{flowopts}
\alias{get_opts}
\alias{load_opts}
\alias{opts_flow}
\alias{set_opts}
\title{Default options/params used in ngsflows and flowr}
\format{\code{opts_flow}}
\usage{
flowopts

opts_flow

get_opts(...)

set_opts(...)

load_opts(...)
}
\arguments{
\item{...}{\itemize{
\item get: names of options to fetch
\item set: a set of options in a name=value format seperated by commas
}}
}
\description{
There are three helper functions which attempt to manage params used by flowr and ngsflows:
\itemize{
\item \link{get_opts} OR \code{opts_flow$get}: show all default options
\item \link{set_opts} OR \code{opts_flow$set}: set default options
\item \link{load_opts} OR \code{opts_flow$load}: load options specified in a tab seperated text file
}
For more details regarding these funtions refer to \link{params}.
}
\details{
By default flowr loads, \code{~/flowr/conf/flowr.conf} and \code{~/flowr/conf/ngsflows.conf}

Below is a list of default flowr options, retrieved via

\code{opts_flow$get()}:
\preformatted{
	|name              |value                    |
	|:-----------------|:------------------------|
	|default_regex     |(.*)                     |
	|flow_base_path    |~/flowr                  |
	|flow_conf_path    |~/flowr/conf             |
	|flow_parse_lsf    |.*(\<[0-9]*\>).*         |
	|flow_parse_moab   |(.*)                     |
	|flow_parse_sge    |(.*)                     |
	|flow_parse_slurm  |(.*)                     |
	|flow_parse_torque |(.?)\..*                 |
	|flow_pipe_paths   |~/flowr/pipelines        |
	|flow_pipe_urls    |~/flowr/pipelines        |
	|flow_platform     |local                    |
	|flow_run_path     |~/flowr/runs             |
	|my_conf_path      |~/flowr/conf             |
	|my_dir            |path/to/a/folder         |
	|my_path           |~/flowr                  |
	|my_tool_exe       |/usr/bin/ls              |
	|time_format       |\%a \%b \%e \%H:\%M:\%S CDT \%Y |
	|verbose           |FALSE                    |
	}
}
\examples{
## Set options: set_opts()
opts = set_opts(flow_run_path = "~/mypath")
## OR if you would like to supply a long list of options:
opts = set_opts(.dots = list(flow_run_path = "~/mypath"))

## load options from a configuration file: load_opts()
myconfile = fetch_conf("flowr.conf")
load_opts(myconfile)

## Fetch options: get_opts()
get_opts("flow_run_path")
get_opts()
}
\keyword{datasets}

