% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\alias{run_flow}
\alias{run_pipe}
\title{Run automated Pipelines}
\usage{
run(
  x,
  platform,
  def,
  conf,
  wd = opts_flow$get("flow_run_path"),
  flow_run_path = wd,
  rerun_wd,
  start_from,
  execute = FALSE,
  ...
)

run_pipe(
  x,
  platform,
  def,
  conf,
  wd = opts_flow$get("flow_run_path"),
  flow_run_path = wd,
  rerun_wd,
  start_from,
  execute = FALSE,
  ...
)
}
\arguments{
\item{x}{name of the pipeline to run. This is a function called to create a flow_mat.}

\item{platform}{what platform to use, overrides flowdef}

\item{def}{flow definition}

\item{conf}{a tab-delimited configuration file with path to tools and default parameters. See \link{fetch_pipes}.}

\item{wd}{an alias to flow_run_path}

\item{flow_run_path}{passed onto to_flow. Default it picked up from flowr.conf. Typically this is ~/flowr/runs}

\item{rerun_wd}{if you need to re-run, supply the previous working dir}

\item{start_from}{the step to start a rerun from. Intuitively, this is ignored in a fresh run and only used in re-running a pipeline.}

\item{execute}{TRUE/FALSE}

\item{...}{passed onto the pipeline function as specified in x}
}
\description{
Run complete pipelines, by wrapping several steps into one 
convenient function.

NOTE: please use flowr version 0.9.8.9010 or higher.

In summary, this function performs the following steps:

\itemize{
\item the argument \code{x} defines the name of the pipeline. 
Say, for example \code{sleep_pipe}.
 \item \link{fetch_pipes}: finds the pipeline definition 
 (\code{sleep_pipe.R}, \code{sleep_pipe.def} and
 \code{sleep_pipe.conf} files)
 \item \code{sleep_pipe(\dots)}: Create all the required commands 
 (\code{flowmat})
  \item \link{to_flow}: Use \code{flowmat} and 
  \code{sleep_pipe.def} to create a flow object.
  \item \link{submit_flow}: Submit the flow to the cluster.
}
}
\examples{
\dontrun{

## Run a short pipeline (dry run)
run("sleep_pipe")

## Run a short pipeline on the local machine
run("sleep_pipe", platform = "local", execute = TRUE)

## Run a short pipeline on the a torque cluster (qsub)
run("sleep_pipe", platform = "torque", execute = TRUE)

## Run a short pipeline on the a MOAB cluster (msub)
run("sleep_pipe", platform = "moab", execute = TRUE)

## Run a short pipeline on the a IBM (LSF) cluster (bsub)
run("sleep_pipe", platform = "lsf", execute = TRUE)

## Run a short pipeline on the a MOAB cluster (msub)
run("sleep_pipe", platform = "moab", execute = TRUE)

## change parameters of the pipeline
## All extra parameters are passed on to the function function.
run("sleep_pipe", platform = "lsf", execute = TRUE, x = 5)

}
}
