% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_0_flow_view.R, R/04_0_flow_run.R
\name{flow_view}
\alias{flow_view}
\alias{flow_run}
\title{View function as flow chart}
\usage{
flow_view(
  x,
  prefix = NULL,
  code = TRUE,
  narrow = FALSE,
  truncate = NULL,
  nested_fun = NULL,
  swap = TRUE,
  out = NULL,
  engine = c("nomnoml", "plantuml")
)

flow_run(
  x,
  prefix = NULL,
  code = TRUE,
  narrow = FALSE,
  truncate = NULL,
  swap = TRUE,
  out = NULL,
  browse = FALSE
)
}
\arguments{
\item{x}{a call, a function, or a path to a script}

\item{prefix}{prefix to use for special comments in our code used as block headers,
must start with \code{"#"}, several prefixes can be provided}

\item{code}{Whether to display the code in code blocks or only the header,
to be more compact, if \code{NA}, the code will be displayed only if no header
is defined by special comments}

\item{narrow}{\code{TRUE} makes sure the diagram stays centered on one column
(they'll be longer but won't shift to the right)}

\item{truncate}{maximum number of characters to be printed per line}

\item{nested_fun}{if not \code{NULL}, the index or name of the function definition found in
x that we wish to inspect}

\item{swap}{whether to change \code{var <- if(cond) expr} into
\code{if(cond) var <- expr} so the diagram displays better}

\item{out}{a path to save the diagram to.
Special values "html", "htm", "png", "pdf", "jpg" and "jpeg" can be used to
export the object to a temp file of the relevant format and open it,
if a regular path is used the format will be guessed from the extension.}

\item{engine}{either \code{"nomnoml"} (default) or \code{"plantuml"} (experimental), if
the latter, arguments \code{prefix}, \code{narrow}, and \code{code}}

\item{browse}{whether to debug step by step (block by block),
can also be a vector of block ids, in this case \code{browser()} calls will be
inserted at the start of these blocks}
}
\value{
\code{flow_view()} returns \code{NULL} invisibly, or the output path invisibly if \code{out} is not
\code{NULL} (called for side effects). \code{flow_run()} returns the output of the wrapped call.
}
\description{
\code{flow_view()} shows the code of a function as a flow diagram, \code{flow_run()}
runs a call and draws the logical path taken by the code.
}
\details{
On some system the output might sometimes display the box character when using
the nomnoml engine, this is due to the system not recognizing the Braille
character \verb{\\u2800}. This character is used to circumvent a nomnoml shortcoming:
lines can't start with a standard space and multiple subsequent spaces might be collapsed.
To choose another character, set the option \code{flow.indenter}, for instance :
\code{options(flow.indenter = "\\u00b7")}.
}
\examples{
flow_view(rle)
flow_run(rle(c(1, 2, 2, 3)))
}
