% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.R
\name{as_flextable.merMod}
\alias{as_flextable.merMod}
\alias{as_flextable.lme}
\alias{as_flextable.gls}
\alias{as_flextable.nlme}
\alias{as_flextable.brmsfit}
\alias{as_flextable.glmmTMB}
\alias{as_flextable.glmmadmb}
\title{Transform a mixed model into a flextable}
\usage{
\method{as_flextable}{merMod}(x, add.random = TRUE, ...)

\method{as_flextable}{lme}(x, add.random = TRUE, ...)

\method{as_flextable}{gls}(x, add.random = TRUE, ...)

\method{as_flextable}{nlme}(x, add.random = TRUE, ...)

\method{as_flextable}{brmsfit}(x, add.random = TRUE, ...)

\method{as_flextable}{glmmTMB}(x, add.random = TRUE, ...)

\method{as_flextable}{glmmadmb}(x, add.random = TRUE, ...)
}
\arguments{
\item{x}{a mixed model}

\item{add.random}{TRUE or FALSE, if TRUE random effects are
added to the table.}

\item{...}{unused argument}
}
\description{
produce a flextable describing a
mixed model. The function is only using package 'broom.mixed'
that provides the data presented in the resulting flextable.

You can remove significance stars by setting options
\code{options(show.signif.stars = FALSE)}.
}
\examples{
if(require("broom.mixed") && require("nlme")){
  m1 <- lme(distance ~ age, data = Orthodont)
  ft <- as_flextable(m1)
  ft
}
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable.data.frame}()},
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.table}()},
\code{\link{as_flextable.tabular}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()},
\code{\link{as_flextable}()}
}
\concept{as_flextable methods}
