% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_chunk.R
\name{prepend_chunks}
\alias{prepend_chunks}
\title{prepend chunks to flextable content}
\usage{
prepend_chunks(x, ..., i = NULL, j = NULL, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{...}{chunks to be prepended, see \code{\link[=as_chunk]{as_chunk()}}, \code{\link[=gg_chunk]{gg_chunk()}} and other
chunk elements for paragraph.}

\item{i}{rows selection}

\item{j}{column selection}

\item{part}{partname of the table (one of 'body', 'header', 'footer')}
}
\description{
prepend chunks (for example chunk \code{\link[=as_chunk]{as_chunk()}})
in a flextable.
}
\examples{
x <- flextable(head(iris))
x <- prepend_chunks(
  x,
  i = 1, j = 1,
  colorize(as_b("coucou "), color = "red")
)
x
}
\seealso{
Other functions for mixed content paragraphs: 
\code{\link{append_chunks}()},
\code{\link{as_paragraph}()},
\code{\link{compose}()}
}
\concept{functions for mixed content paragraphs}
