% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{font}
\alias{font}
\title{Set font}
\usage{
font(
  x,
  i = NULL,
  j = NULL,
  fontname,
  part = "body",
  cs.family = fontname,
  hansi.family = fontname,
  eastasia.family = fontname
)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{fontname}{single character value. With Word and PowerPoint output, the value specifies the font to
be used to format characters in the Unicode range (U+0000-U+007F).}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}

\item{cs.family}{Optional font to be used to format
characters in a complex script Unicode range. For example, Arabic
text might be displayed using the "Arial Unicode MS" font.
Used only with Word and PowerPoint outputs. Its default value is the value
of \code{fontname}.}

\item{hansi.family}{optional. Specifies the font to be used to format
characters in a Unicode range which does not fall into one of the
other categories.
Used only with Word and PowerPoint outputs. Its default value is the value
of \code{fontname}.}

\item{eastasia.family}{optional font to be used to
format characters in an East Asian Unicode range. For example,
Japanese text might be displayed using the "MS Mincho" font.
Used only with Word and PowerPoint outputs. Its default value is the value
of \code{fontname}.}
}
\description{
change font of selected rows and columns of a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_font_1.png}{options: width="500"}}

\if{html}{\figure{fig_font_2.png}{options: width="500"}}
}

\examples{
require("gdtools")
fontname <- "Brush Script MT"

if (font_family_exists(fontname)) {
  ft_1 <- flextable(head(iris))
  ft_2 <- font(ft_1, fontname = fontname, part = "header")
  ft_2 <- font(ft_2, fontname = fontname, j = 5)
  ft_2
}
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
