% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{knit_print.flextable}
\alias{knit_print.flextable}
\title{Render flextable in rmarkdown}
\usage{
\method{knit_print}{flextable}(x, ...)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{...}{further arguments, not used.}
}
\description{
Function used to render flextable in knitr/rmarkdown documents.
HTML, Word and PowerPoint outputs are supported.
}
\note{
For Word (docx) output, if pandoc version >= 2.0 is used, a raw XML block
with the table code will be inserted. If pandoc version < 2.0 is used, an
error will be raised. Insertion of images is not supported
with rmarkdown for Word documents (use the package officedown instead).
For PowerPoint (pptx) output, if pandoc version < 2.4 is used, an error
will be raised.
}
\section{HTML chunk options}{

Result can be aligned with chunk option \code{ft.align} that
accepts values 'left', 'center' and 'right'.
}

\section{Word chunk options}{

Result can be aligned with chunk option \code{ft.align} that
accepts values 'left', 'center' and 'right'.

Word option 'Allow row to break across pages' can be
activated with chunk option \code{ft.split} set to TRUE.

To specify a Word style for table caption use chunk option
\code{tab.cap.style}. The default value is "Table Caption".
}

\section{PowerPoint chunk options}{

Position should be defined with options \code{ft.left}
and \code{ft.top}. Theses are the top left coordinates
of the placeholder that will contain the table. They
default to \code{{r ft.left=1, ft.left=2}}.
}

\section{PDF chunk options}{


Using flextable with template \code{pdf_document} is OK if the
flextable fits on one single page. The PDF output is not
a real latex output but a PNG image generated with package
'webshot' or package 'webshot2'. Package 'webshot2' should
be prefered as 'webshot' can have issues with some properties
(i.e. bold are not rendered for some users).

To specify usage of 'webshot2', use chunk option \code{webshot="webshot2"}.
}

\examples{

# simple examples -----
demo_docx <- system.file(package = "flextable", "examples/rmd", "demo.Rmd")
rmd_file <- tempfile(fileext = ".Rmd")
file.copy(demo_docx, to = rmd_file, overwrite = TRUE)
rmd_file # R Markdown document used for demo
if(require("rmarkdown", quietly = TRUE)){
#  knitr::opts_chunk$set(webshot = "webshot2")
#  render(input = rmd_file, output_format = "word_document", output_file = "doc.docx")
#  render(input = rmd_file, output_format = "pdf_document", output_file = "doc.pdf")
#  render(input = rmd_file, output_format = "html_document", output_file = "doc.html")
#  render(input = rmd_file, output_format = "powerpoint_presentation", output_file = "pres.pptx")
#  render(input = rmd_file, output_format = "slidy_presentation", output_file = "slidy.html")
#  render(input = rmd_file, output_format = "beamer_presentation", output_file = "beamer.pdf")
#  render(input = rmd_file, output_format = "pagedown::html_paged", output_file = "paged.html")
}


# looping examples for Word output -----
demo_loop <- system.file(package = "flextable", "examples/rmd", "loop_docx.Rmd")
rmd_file <- tempfile(fileext = ".Rmd")
file.copy(demo_loop, to = rmd_file, overwrite = TRUE)
rmd_file # R Markdown document used for demo
if(require("rmarkdown", quietly = TRUE)){
#  render(input = rmd_file, output_format = "word_document", output_file = "loop_docx.docx")
}

# looping examples for HTML output -----
demo_loop <- system.file(package = "flextable", "examples/rmd", "loop_html.Rmd")
rmd_file <- tempfile(fileext = ".Rmd")
file.copy(demo_loop, to = rmd_file, overwrite = TRUE)
rmd_file # R Markdown document used for demo
if(require("rmarkdown", quietly = TRUE)){
#  render(input = rmd_file, output_format = "html_document", output_file = "loop_html.html")
}
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{docx_value}()},
\code{\link{htmltools_value}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()}
}
\author{
Maxim Nazarov
}
\concept{flextable print function}
