% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_image}
\alias{as_image}
\title{image chunk wrapper}
\usage{
as_image(src, width = 0.5, height = 0.2, ...)
}
\arguments{
\item{src}{image filename}

\item{width, height}{size of the png file in inches}

\item{...}{unused argument}
}
\description{
The function lets add images within flextable
objects with function \code{\link{compose}}.
It should be used inside a call to \code{\link{as_paragraph}}.
}
\note{
PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\examples{
img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
library(officer)

myft <- flextable( head(iris))

myft <- compose( myft, i = 1:3, j = 1,
 value = as_paragraph(
   as_image(src = img.file, width = .20, height = .15),
   " blah blah ",
   as_chunk(Sepal.Length, props = fp_text(color = "red"))
 ),
 part = "body")

autofit(myft)
}
\seealso{
\code{\link{compose}}, \code{\link{as_paragraph}}

Other chunk elements for paragraph: \code{\link{as_chunk}},
  \code{\link{hyperlink_text}}, \code{\link{minibar}}
}
\concept{chunk elements for paragraph}
