% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_bmat.R
\name{sim_bmat}
\alias{sim_bmat}
\title{Randomly Generate FMP Parameters}
\usage{
sim_bmat(n_items, k, xi_dist = c(-1, 1), omega_dist = c(-1, 1),
  alpha_dist = c(-1, 0.5), tau_dist = c(-7, -1))
}
\arguments{
\item{n_items}{Number of items for which to simulate item parameters.}

\item{k}{Either a scalar for the item complexity of all items or a
vector of length n_items if different items have different item
complexities.}

\item{xi_dist}{Vector of two elements indicating the lower and upper
bounds of the uniform distribution from which to draw xsi parameters.}

\item{omega_dist}{Vector of two elements indicating the lower and upper
bounds of the uniform distribution from which to draw omega parameters.}

\item{alpha_dist}{Vector of two elements indicating the lower and upper
bounds of the uniform distribution from which to draw alpha parameters.
Ignored if all k = 0.}

\item{tau_dist}{Vector of two elements indicating the lower and upper
bounds of the uniform distribution from which to draw tau parameters.
Ignored if all k = 0.}
}
\value{
\item{bmat}{Item parameters in the b parameterization (polynomial
coefficients).}
\item{greekmat}{Item parameters in the Greek-letter parameterization}
}
\description{
Generate monotonic polynomial coefficients for user-specified item
complexities and prior distributions.
}
\details{
Randomly generate FMP item parameters for a given k value.
}
\examples{
## generate FMP item parameters for 5 items all with k = 2
set.seed(2342)
pars <- sim_bmat(n_items = 5, k = 2)
pars$bmat

## generate FMP item parameters for 5 items with varying k values
set.seed(2432)
pars <- sim_bmat(n_items = 5, k = c(1, 2, 0, 0, 2))
pars$bmat

}
