% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getDepthLevel}
\alias{fxml_getDepthLevel}
\title{Handling flat XML files}
\usage{
fxml_getDepthLevel(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
The number of the hierarchy level of the XML element with ID \code{elemid}. The root node of the XML data has hierarchy level 1.
}
\description{
Hierarchical position of an XML element
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Determine hierarchy level of XML element with ID 3 (xml.dataframe$elemid. ==  3)
fxml_getDepthLevel(xml.dataframe, 3)

}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
