% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_interaction.R
\name{light_interaction}
\alias{light_interaction}
\alias{light_interaction.default}
\alias{light_interaction.flashlight}
\alias{light_interaction.multiflashlight}
\title{Interaction Strength}
\usage{
light_interaction(x, ...)

\method{light_interaction}{default}(x, ...)

\method{light_interaction}{flashlight}(x, data = x$data, by = x$by,
  v = NULL, n_max = 50, center_at = c("middle", "first", "last"),
  seed = NULL, use_linkinv = FALSE, n_bins = 9, indices = NULL,
  value_name = "value", error_name = "error", label_name = "label",
  variable_name = "variable", ...)

\method{light_interaction}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed to or from other methods.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{v}{Vector of variables to be assessed.}

\item{n_max}{If \code{indices} is not given, maximum number of rows to consider. Will be randomly picked from \code{data} if necessary.}

\item{center_at}{Which evaluation point to center at. One of "first", "middle", or "last".}

\item{seed}{An integer random seed.}

\item{use_linkinv}{Should retransformation function be applied? Default is FALSE.}

\item{n_bins}{Maximum number of unique values to evaluate for numeric \code{v}.}

\item{indices}{A vector of row numbers to consider.}

\item{value_name}{Column name in resulting \code{data} containing the interaction strenght. Defaults to "value".}

\item{error_name}{Currently not used.}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{variable_name}{Column name in resulting \code{data} containing the variable names. Defaults to "variable".}
}
\value{
An object of class \code{light_importance}, \code{light} (and a list) with the following elements.
\itemize{
  \item \code{data} A tibble containing the results. Can be used to build fully customized visualizations. Its column names are specified by the items in this list (except for "method").
  \item \code{by} Same as input \code{by}.
  \item \code{value_name} Same as input \code{value_name}.
  \item \code{error_name} Same as input \code{error_name}.
  \item \code{label_name} Same as input \code{label_name}.
  \item \code{variable_name} Same as input \code{variable_name}.
}
}
\description{
Calculates overall interaction strength per covariable by calculating the average within-evaluation-point standard deviation across centered ICE curves, see the vignette for details. Additive covariable effects get a value of 0, while covariables with interaction effects get positive values as their c-ICE curves differ. While relatively efficient to calculate, this method does not show between what specific variable pairs we have strongest interactions. Note that continuous variables are binned using quantile cuts to get more stable results. For the same reason, centering of ICE curves is done using middle centering.
}
\details{
The minimum required elements in the (multi-)flashlight are "predict_function", "model", "linkinv" and "data", where the latest can be passed on the fly. Which rows in \code{data} are profiled? This is specified by \code{indices}. If not given and \code{n_max} is smaller than the number of rows in \code{data}, then row indices will be sampled randomly from \code{data}. If the same rows should be used for all flashlights in a multiflashlight, there are two options: Either pass a \code{seed} (with potentially undesired consequences for subsequent code) or a vector of indices used to select rows. In both cases, \code{data} should be the same for all flashlights considered.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Univariate interaction strengths for a flashlight object.

\item \code{multiflashlight}: for a multiflashlight object.
}}

\examples{
fit_additive <- lm(Sepal.Length ~ Petal.Length + Petal.Width, data = iris)
fit_nonadditive <- lm(Sepal.Length ~ Petal.Length * Petal.Width, data = iris)
fl_additive <- flashlight(model = fit_additive, label = "additive")
fl_nonadditive <- flashlight(model = fit_nonadditive, label = "nonadditive")
fls <- multiflashlight(list(fl_additive, fl_nonadditive), data = iris, y = "Sepal.Length")
plot(light_interaction(fls))
plot(light_interaction(fls, by = "Species"), swap_dim = TRUE)
}
\seealso{
\code{\link{light_ice}}.
}
