% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_missing_alphanumeric_values.R
\name{fix_missing_alphanumeric_values}
\alias{fix_missing_alphanumeric_values}
\title{Fill missing values in alphanumeric columns}
\usage{
fix_missing_alphanumeric_values(df)
}
\arguments{
\item{df}{A data frame with missing values.}
}
\value{
A data frame with imputed missing values.
}
\description{
This function imputes missing values in alphanumeric columns of a data frame. If a column
is numeric, missing values are imputed with the column mean. Otherwise, missing values
are imputed with the column mode (most common value).
}
\examples{
df <- data.frame(w = c(7, 8, 180, 7), x = c("a", "b", "c", NA),
                 y = c(4, 5, -6, 4), z = c(7, 8, NA, 7))
fix_missing_alphanumeric_values(df)

}
