% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_multi.R
\name{[[.fixest_multi}
\alias{[[.fixest_multi}
\title{Extracts one element from a \code{fixest_multi} object}
\usage{
\method{[[}{fixest_multi}(x, i)
}
\arguments{
\item{x}{A \code{fixest_multi} object, obtained from a \code{fixest} estimation leading to multiple results.}

\item{i}{An integer scalar. The identifier of the estimation to extract.}
}
\value{
A \code{fixest} object is returned.
}
\description{
Extracts single elements from multiple \code{fixest} estimations.
}
\examples{

base = iris
names(base) = c("y", "x1", "x2", "x3", "species")

# Multiple estimation
res = feols(y ~ csw(x1, x2, x3), base, split = ~species)

# The first estimation
res[[1]]

# The second one, etc
res[[2]]

}
\seealso{
The main fixest estimation functions: \code{\link[fixest]{feols}}, \code{\link[fixest:feglm]{fepois}}, \code{\link[fixest:femlm]{fenegbin}}, \code{\link[fixest]{feglm}}, \code{\link[fixest]{feNmlm}}. Tools for mutliple fixest estimations: \code{\link[fixest]{summary.fixest_multi}}, \code{\link[fixest]{print.fixest_multi}}, \code{\link[fixest]{as.list.fixest_multi}}, \code{\link[fixest]{sub-sub-.fixest_multi}}, \code{\link[fixest]{sub-.fixest_multi}}, \code{\link[fixest]{cash-.fixest_multi}}.
}
