% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{summary.fixest.fixef}
\alias{summary.fixest.fixef}
\title{Summary method for cluster coefficients}
\usage{
\method{summary}{fixest.fixef}(object, n = 5, ...)
}
\arguments{
\item{object}{An object returned by the function \code{\link[fixest]{fixef.fixest}}.}

\item{n}{Positive integer, defaults to 5. The \code{n} first fixed-effects for each cluster are reported.}

\item{...}{Not currently used.}
}
\value{
It prints the number of fixed-effect coefficients per cluster, as well as the number of fixed-effects used as references for each cluster, and the mean and variance of the cluster coefficients. Finally it reports the first 5 elements of each cluster.
}
\description{
This function summarizes the main characteristics of the cluster coefficients. It shows the number of fixed-effects that have been set as references and the first elements of the fixed-effects.
}
\examples{

data(trade)

# We estimate the effect of distance on trade
# => we account for 3 fixed-effects effects
est_pois = femlm(Euros ~ log(dist_km)|Origin+Destination+Product, trade)

# obtaining the fixed-effects coefficients
fe_trade = fixef(est_pois)

# printing some summary information on the cluster coefficients:
summary(fe_trade)


}
\seealso{
\code{\link[fixest]{femlm}}, \code{\link[fixest]{fixef.fixest}}, \code{\link[fixest]{plot.fixest.fixef}}.
}
\author{
Laurent Berge
}
