% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCOV.R, R/alias_VCOV.R
\name{vcov_conley}
\alias{vcov_conley}
\alias{conley}
\title{Conley VCOV}
\usage{
vcov_conley(
  x,
  lat = NULL,
  lon = NULL,
  cutoff = NULL,
  pixel = 0,
  distance = "triangular",
  ssc = NULL,
  vcov_fix = TRUE
)

conley(cutoff = NULL, pixel = NULL, distance = NULL)
}
\arguments{
\item{x}{A \code{fixest} object.}

\item{lat}{A character scalar or a one sided formula giving the name of the variable
representing the latitude. The latitude must lie in [-90, 90], [0, 180] or [-180, 0].}

\item{lon}{A character scalar or a one sided formula giving the name of the variable
representing the longitude. The longitude must be in [-180, 180], [0, 360] or [-360, 0].}

\item{cutoff}{The distance cutoff, in km. You can express the cutoff in miles by writing the
number in character form and adding "mi" as a suffix: cutoff = "100mi" would be 100 miles. If
missing, a rule of thumb is used to deduce the cutoff.}

\item{pixel}{A positive numeric scalar, default is 0. If a positive number, the coordinates of
each observation are pooled into \code{pixel} x \code{pixel} km squares. This lowers the precision but can
(depending on the cases) greatly improve computational speed at a low precision cost. Note that
if the \code{cutoff} was expressed in miles, then \code{pixel} will also be in miles.}

\item{distance}{How to compute the distance between points. It can be equal to "triangular"
(default) or "spherical". The latter case corresponds to the great circle distance and is more
precise than triangular but is a bit more intensive computationally.}

\item{ssc}{An object returned by the function \code{\link{ssc}}. It specifies how to perform the small
sample correction.}

\item{vcov_fix}{Logical scalar, default is \code{TRUE}. If the VCOV ends up not being
positive definite, whether to "fix" it using an eigenvalue decomposition
(a la Cameron, Gelbach & Miller 2011).}
}
\value{
If the first argument is a \code{fixest} object, then a VCOV is returned (i.e. a symmetric matrix).

If the first argument is not a \code{fixest} object, then a) implicitly the arguments are shifted to
the left (i.e. \code{vcov_conley("lat", "long")} is equivalent to
\code{vcov_conley(lat = "lat", lon = "long")}) and b) a VCOV-\emph{request} is returned and NOT a VCOV.
That VCOV-request can then be used in the argument \code{vcov} of various \code{fixest} functions
(e.g. \code{\link{vcov.fixest}} or even in the estimation calls).
}
\description{
Compute VCOVs robust to spatial correlation, a la Conley (1999).
}
\details{
This function computes VCOVs that are robust to spatial correlations by assuming a correlation
between the units that are at a geographic distance lower than a given cutoff.

The kernel is uniform.

If the cutoff is not provided, an estimation of it is given. This cutoff ensures that a minimum
of units lie within it and is robust to sub-sampling. This automatic cutoff is only here for
convenience, the most appropriate cutoff shall depend on the application and shall be provided
by the user.

The function \code{conley} does not compute VCOVs directly but is meant to be used in the argument
\code{vcov} of \code{fixest} functions (e.g. in \code{\link{vcov.fixest}} or even in the estimation calls).
}
\examples{

data(quakes)

# We use conley() in the vcov argument of the estimation
feols(depth ~ mag, quakes, conley(100))

# Post estimation
est = feols(depth ~ mag, quakes)
vcov_conley(est, cutoff = 100)



}
\references{
Conley TG (1999). "GMM Estimation with Cross Sectional Dependence", \emph{Journal of Econometrics}, 92, 1-45.
}
