% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_meredith.R
\docType{data}
\name{mlb_elo}
\alias{mlb_elo}
\title{MLB Elo}
\format{Because of R package size restrictions, only a preview of the
first 10 rows of this dataset is included; to obtain the entire dataset
(1871 to 2017 games) see Examples below. A data frame with 10 rows
representing Elo ratings and 26 variables:
\describe{
  \item{date}{The date of the game.}
  \item{season}{The season within which the game was played.}
  \item{neutral}{No description provided.}
  \item{playoff}{No description provided.}
  \item{team1}{One team that participated in the game.}
  \item{team2}{The other team that participated in the match.}
  \item{elo1_pre}{The Elo rating for team1 prior to the game.}
  \item{elo2_pre}{The Elo rating for team2 prior to the game.}
  \item{elo_prob1}{No description provided.}
  \item{elo_prob2}{No description provided.}
  \item{elo1_post}{The Elo rating for team1 after the game.}
  \item{elo2_post}{The Elo rating for team2 after the game.}
  \item{rating1_pre}{No description provided.}
  \item{rating2_pre}{No description provided.}
  \item{pitcher1}{An identifier of the pitcher}
  \item{pitcher2}{No description provided.}
  \item{pitcher1_rating}{No description provided.}
  \item{pitcher2_rating}{No description provided.}
  \item{pitcher1_adj}{No description provided.}
  \item{pitcher2_adj}{No description provided.}
  \item{rating_prob1}{No description provided.}
  \item{rating_prob2}{No description provided.}
  \item{rating1_post}{No description provided.}
  \item{rating2_post}{No description provided.}
  \item{score1}{The number of runs scored by team1.}
  \item{score2}{The number of runs scored by team2.}
}}
\source{
See \url{https://github.com/fivethirtyeight/data/blob/master/mlb-elo/README.md}
}
\usage{
mlb_elo
}
\description{
The raw data behind the stories:
"The Complete History Of MLB" \url{https://projects.fivethirtyeight.com/complete-history-of-mlb/}
and "MLB Predictions" \url{https://projects.fivethirtyeight.com/2017-mlb-predictions/}.
}
\examples{
# To obtain the entire dataset, run the code inside the following if statement:
if(FALSE){
  library(tidyverse)
  mlb_elo <- read_csv("https://projects.fivethirtyeight.com/mlb-api/mlb_elo.csv") \%>\%
    mutate(
      playoff = as.factor(playoff),
      playoff = ifelse(playoff == "<NA>", NA, playoff),
      neutral = as.logical(neutral)
    )
}
}
\keyword{datasets}
