% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{generate_token}
\alias{generate_token}
\title{Generate a Fitbit API token}
\usage{
generate_token(
  client_id,
  client_secret,
  callback = "http://localhost:1410/",
  scope = c("sleep", "activity", "heartrate", "location", "nutrition", "profile",
    "settings", "social", "weight"),
  cache = FALSE,
  use_basic_auth = TRUE,
  ...
)
}
\arguments{
\item{client_id}{your Fitbit client ID}

\item{client_secret}{your Fitbit client secret}

\item{callback}{your Fitbit redirect URL}

\item{scope}{the scopes to enable}

\item{cache}{Do you want to cache your token? See \link[httr]{oauth2.0_token} for details}

\item{use_basic_auth}{A boolean for whether or not to use basic auth in \link[httr]{oauth2.0_token}. Defaults to \code{TRUE}}

\item{...}{additional arguments to be passed to \link[httr]{oauth2.0_token}}
}
\value{
No return value. This function generates a token and saves it (hidden) in the global environment to be used for the remainder of the R session. You can cache this token with \code{cache = TRUE} or explicitly setting a filepath to cache to. See \link[httr]{oauth2.0_token} for details.
}
\description{
Simplify the setup process by persisting your Fitbit client_id and secret in the \code{.fitbitr-oauth} file.
}
\examples{
\dontrun{
generate_token(
  client_id = <YOUR-CLIENT-ID>
  client_secret = <YOUR-CLIENT-SECRET>,
  cache = TRUE
)
}
}
