% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bait.gfw.effort.R
\name{bait.gfw.effort}
\alias{bait.gfw.effort}
\title{Prepare a query request for GFW fishing effort data}
\usage{
bait.gfw.effort(
  table,
  start_date,
  end_date,
  min_lat,
  max_lat,
  min_lon,
  max_lon,
  min_hours,
  max_hours,
  min_fishing_hours,
  max_fishing_hours,
  min_mmsi_present,
  max_mmsi_present,
  flag,
  geartype,
  mmsi
)
}
\arguments{
\item{table}{Character. The table you want to query. Available tables are 'fishing_effort_v2' (resolution of 0.01 degrees latitude by 0.01 degrees of longitude) and 'fishing_effort_byvessel_v2' (resolution of 0.1 degrees latitude by 0.1 degrees of longitude).}

\item{start_date, end_date}{Optional. Characters. Date (yyyy-mm-dd) boundaries. Start and end values are included.}

\item{min_lat, max_lat}{Optional. Numbers. Latitude boundaries. Minimum and maximum values are included.}

\item{min_lon, max_lon}{Optional. Numbers. Longitude boundaries. Minimum and maximum values are included.}

\item{min_hours, max_hours}{Optional. Numbers. Minimum and maximum hours (not fishing hours) per grid cell per date. Minimum and maximum values are included.}

\item{min_fishing_hours, max_fishing_hours}{Optional. Numbers. Minimum and maximum fishing hours per grid cell per date. Minimum and maximum values are included.}

\item{min_mmsi_present, max_mmsi_present}{Optional. Numbers. Minimum and maximum number of different MMSI numbers present per grid cell per date. Minimum and maximum values are included. Only available for table 'fishing_effort_v2'.}

\item{flag}{Optional. A character vector. ISO3 Codes of the flag states of the boats streaming the data. Only available for table 'fishing_effort_v2'.}

\item{geartype}{Optional. A character vector. The main geartype (fishing gear) of the boat streaming the data. Only available for table 'fishing_effort_v2'.}

\item{mmsi}{Optional. Characters. Pattern (regular expression) to look for in the MMSI number of the boats. Only available for table 'fishing_effort_byvessel_v2'.}
}
\value{
A character scalar (bait) to pass to `fish()`. The scalar contains the endpoint of the http GET request.
}
\description{
Preliminary function to prepare a 'bait' (API endpoint) to `fish()` for GFW fishing effort data via fishRman's API.
}
\examples{
\donttest{
bait <- bait.gfw.effort(table = "fishing_effort_byvessel_v2", end_date="2012-01-02")

print(bait)

# "/gfw?table=fishing_effort_v2&end_date=2012-01-02"
}
}
\seealso{
[fish()]
}
