% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{intraday_transmission_capacity_FI_to_RUS}
\alias{intraday_transmission_capacity_FI_to_RUS}
\title{Intraday transmission capacity FI-RUS}
\usage{
intraday_transmission_capacity_FI_to_RUS(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the capacity given to intraday
market means transfer capacity after day-ahead trade from
Finland (FI) to Russia (RUS). The indraday capacity between Finland and
Russia is updated once a day. The data will not be revised after
hourly day-ahead trade.
}
\description{
Check https://data.fingrid.fi/en/dataset/intraday-transmission-capacity-fi-rus
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- intraday_transmission_capacity_FI_to_RUS(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
