% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwca_validate.R
\name{dwca_validate}
\alias{dwca_validate}
\title{Validate a Darwin Core Archive}
\usage{
dwca_validate(x, ifModifiedSince = NULL, browse = FALSE, ...)
}
\arguments{
\item{x}{(character) A url for a Darwin Core Archive. If you have a local
Darwin Core Archive, put it up online somewhere. Required.}

\item{ifModifiedSince}{(character) An optional ISO date (yyyy-mm-dd) to
enable conditional get requests, validating archives only if they have
been modified since the given date. This feature requires the archive url
to honor the if-modified-since http header. Apache webservers for example
do this out of the box for static files, but if you use dynamic scripts
to generate the archive on the fly this might not be recognised. Optional.}

\item{browse}{(logical) Browse to generated report or not.
Default: \code{FALSE}}

\item{...}{Curl options passed to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Validate a Darwin Core Archive
}
\details{
Uses the GBIF DCA validator (http://tools.gbif.org/dwca-validator/)
}
\examples{
\dontrun{
x <- "http://rs.gbif.org/datasets/german_sl.zip"
dwca_validate(x)
}
}
